window.addEventListener('load', function(){

    let images = [
        {path: "images/adorable-cat.jpg", description: "An adorable cat staring at you"},
        {path: "images/eppy-cat.jpg", description: "A cat that is very sleepy"},
        {path: "images/silly-hippo.jpg", description: "A silly looking hippo"},
        {path: "images/startled-cat.jpg", description: "A cat that looks very startled"}
    ];

    const mainImg = document.getElementById("mainImg");
    const caption = document.getElementById("caption");
    const btnPrev = document.getElementById("btnPrev");
    const btnNext = document.getElementById("btnNext");

    let currentImg = 0

    function showImage(imgObj){
        mainImg.src = imgObj.path;
        mainImg.alt = imgObj.description;
        caption.innerHTML = imgObj.description;
    }

    showImage(images[currentImg])

    btnNext.addEventListener("click", function(){
        currentImg++
        if(currentImg == images.length){
            currentImg = 0;
        }
        showImage(images[currentImg])
    })

    btnPrev.addEventListener("click", function(){
        currentImg--
        if(currentImg < 0){
            currentImg = images.length - 1
        }
        showImage(images[currentImg])
    })
})